globals [x-current x-new x-current' x-new' num-turtles-created turtlex0-who turtlex0'-who]

to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  set num-turtles-created -1; first turtle created will be number 0
  draw-axes
  draw-parabola

  set x-current x0
  set x-new (R * x-current * (1 - x-current))  ; logistic map

  create-turtles 1; this turtle will plot x_{t+1} vs x_t using initial condition x0
  [
    set color blue
    set xcor (x-current * max-pxcor)
    set ycor (x-new * max-pycor)
    set shape "dot"
    set size 5
  ]
  set num-turtles-created num-turtles-created + 1
  set turtlex0-who num-turtles-created   ; "id number" for this turtle

  set x-current' x0'
  set x-new' (R * x-current' * (1 - x-current'))  ; logistic map

  create-turtles 1; this turtle will plot x_{t+1} vs x_t using initial condition x0'
    [
      set color red
      set xcor (x-current' * max-pxcor)
      set ycor (x-new' * max-pycor)
      set shape "dot"
      set size 3
    ]
  set num-turtles-created num-turtles-created + 1
  set turtlex0'-who num-turtles-created  ; "id number" for this turtle
end

to go
  iterate  ; do one iteration of logistic map
;  update-plot
  wait .1
  tick  ; increase tick number by 1
end

to iterate
  set x-current x-new
  set x-new (R * x-current * (1 - x-current))  ; one iteration of logistic map
  ask turtle turtlex0-who
  [
      set xcor (x-current * max-pxcor)  ; update coordinates for turtle representing first initial condition
      set ycor (x-new * max-pycor)
  ]
  set x-current' x-new'
  set x-new' (R * x-current' * (1 - x-current'))  ; one iteration of logistic map
  ask turtle turtlex0'-who
    [
      set xcor (x-current' * max-pxcor)  ; update coordinates for turtle representing second initial condition
      set ycor (x-new' * max-pycor)
    ]
end

to draw-axes   ; draws x and y axes
  ask patches
    [set pcolor white]
  create-turtles 1
  set num-turtles-created num-turtles-created + 1
  ask turtles
  [
    set color black
    set xcor min-pxcor
    set ycor min-pycor
    set heading 0
    pen-down
    fd max-pycor   ; draw y axis
    pen-up
    set xcor min-pxcor
    set ycor min-pycor
    set heading 90
    pen-down
    fd max-pxcor  ; draw x axis
    die
  ]
end

to draw-parabola  ; draws parabola representing logistic map for given value of R
 let x 0
 let y 0
 create-turtles 1
 set num-turtles-created num-turtles-created + 1
  ask turtles
  [
    set color black
    set xcor x * min-pxcor
    set ycor y * min-pycor
    pen-down
  ]
  repeat 10000
  [
    set x (x + .0001)
    ask turtles
    [
      set xcor (x * max-pxcor)
      set ycor (R * x * (1 - x)) * max-pycor
    ]
  ]
  ask turtles [die]
end

;;plotting procedures -------------------

to setup-plot
  set-current-plot "logistic map"
  set-plot-x-range  0 1
  set-plot-y-range  0 1
end

to update-plot
  set-current-plot-pen "x"
  plot x-current
end
@#$#@#$#@
GRAPHICS-WINDOW
293
45
603
356
-1
-1
9.152
1
10
1
1
1
0
0
0
1
0
32
0
32
0
0
1
ticks
30.0

BUTTON
87
256
162
295
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
256
88
295
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
11
101
223
134
R
R
0
4
3.9
0.01
1
NIL
HORIZONTAL

SLIDER
11
137
223
170
x0
x0
0
1
0.2
0.00001
1
NIL
HORIZONTAL

PLOT
24
404
606
581
Logistic map
time t (* 10)
x_t
0.0
5.0
0.0
1.0
true
true
"" ""
PENS
"x{t}" 0.1 0 -13345367 true "" "plot x-current"
"x'{t}" 0.1 0 -2674135 true "" "plot x-current'"

MONITOR
6
329
72
374
x{t}
x-current
4
1
11

MONITOR
71
329
137
374
x{t+1}
x-new
4
1
11

TEXTBOX
257
210
300
228
x\n
14
0.0
1

TEXTBOX
428
382
443
400
x
14
0.0
1

TEXTBOX
264
70
292
88
1.0
14
0.0
1

TEXTBOX
274
362
289
380
0
14
0.0
1

TEXTBOX
300
378
315
396
0
14
0.0
1

TEXTBOX
583
383
606
401
1.0
14
0.0
1

TEXTBOX
12
10
340
64
Logistic Map: Sensitive Dependence on Initial Conditions
18
95.0
1

TEXTBOX
373
10
571
66
x     = R x  (1 - x  )
16
0.0
1

TEXTBOX
385
18
410
36
t+1
11
0.0
1

TEXTBOX
451
18
466
36
t
11
0.0
1

TEXTBOX
506
17
521
35
t
11
0.0
1

TEXTBOX
16
67
166
87
Set Parameters:
16
0.0
1

TEXTBOX
14
226
180
266
Iterate logistic map:
16
0.0
1

TEXTBOX
267
218
294
236
t+1
11
0.0
1

TEXTBOX
440
388
455
406
t
11
0.0
1

BUTTON
160
256
223
295
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
11
176
223
209
x0'
x0'
0
1
0.20001
.00001
1
NIL
HORIZONTAL

MONITOR
144
329
209
374
x'{t}
x-current'
17
1
11

MONITOR
206
329
267
374
x'{t+1}
x-new'
17
1
11

TEXTBOX
46
306
99
326
First x
16
105.0
1

TEXTBOX
168
306
240
326
Second x
16
15.0
1

@#$#@#$#@
## WHAT IS IT?

This model demonstrates sensitive dependence on initial conditions in the logistic map, x{t+1} = R x{t} (1 - x{t}).  This sensitive dependence is seen when R is in the chaotic regime. 

## HOW IT WORKS

This model is very similar to LogisticMap.nlogo.  The only difference is that there is a second time series (x{t}, x{t+1}), with its own initial condition.  We see the first time series in red, and the second in blue.  By setting R to be in the chaotic regime and the two initial conditions (x{0} and x'{0}) to be very close to each other (but not exactly equal), it can be seen how a very small difference in the initial condition can produce very large, and hard-to-predict differences in the behavior of the systems. 

## HOW TO USE IT

Use this model in the same way you used LogisticMap.nlogo, but in addition set the value of x'{0}.  

## CREDITS AND REFERENCES

This model is part of the Dynamics series of the Complexity Explorer project.  
 
Main Author:  Melanie Mitchell

Contributions from:  John Balwit

Netlogo:  Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.


## HOW TO CITE

If you use this model, please cite it as: "Sensitive Dependence" model, Complexity Explorer project, http://complexityexplorer.org

## COPYRIGHT AND LICENSE

Copyright 2013 Santa Fe Institute.  

This model is licensed by the Creative Commons Attribution-NonCommercial-NoDerivs 3.0 License ( http://creativecommons.org/licenses/by-nc-nd/3.0/ ). This states that you may copy, distribute, and transmit the work under the condition that you give attribution to ComplexityExplorer.org, and your use is for non-commercial purposes.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
